/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.message.server;

import java.io.IOException;
import java.sql.SQLException;
import net.skinsrestorer.shadow.mariadb.ServerPreparedStatement;
import net.skinsrestorer.shadow.mariadb.client.Client;
import net.skinsrestorer.shadow.mariadb.client.Column;
import net.skinsrestorer.shadow.mariadb.client.Completion;
import net.skinsrestorer.shadow.mariadb.client.Context;
import net.skinsrestorer.shadow.mariadb.client.ReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.client.socket.Reader;
import net.skinsrestorer.shadow.mariadb.export.Prepare;
import net.skinsrestorer.shadow.mariadb.message.server.ColumnDefinitionPacket;
import net.skinsrestorer.shadow.mariadb.util.log.Logger;
import net.skinsrestorer.shadow.mariadb.util.log.Loggers;

public class PrepareResultPacket
implements Completion,
Prepare {
    private static final Logger logger = Loggers.getLogger(PrepareResultPacket.class);
    private final Column[] parameters;
    private Column[] columns;
    protected int statementId;

    public PrepareResultPacket(ReadableByteBuf buffer, Reader reader, Context context) throws IOException {
        int i;
        boolean trace = logger.isTraceEnabled();
        buffer.readByte();
        this.statementId = buffer.readInt();
        int numColumns = buffer.readUnsignedShort();
        int numParams = buffer.readUnsignedShort();
        this.parameters = new Column[numParams];
        this.columns = new Column[numColumns];
        if (numParams > 0) {
            for (i = 0; i < numParams; ++i) {
                this.parameters[i] = new ColumnDefinitionPacket(reader.readPacket(false, trace), context.hasClientCapability(0x800000000L));
            }
            if (!context.isEofDeprecated()) {
                reader.readPacket(true, trace);
            }
        }
        if (numColumns > 0) {
            for (i = 0; i < numColumns; ++i) {
                this.columns[i] = new ColumnDefinitionPacket(reader.readPacket(false, trace), context.hasClientCapability(0x800000000L));
            }
            if (!context.isEofDeprecated()) {
                reader.readPacket(true, trace);
            }
        }
    }

    @Override
    public void close(Client con) throws SQLException {
        con.closePrepare(this);
    }

    @Override
    public void decrementUse(Client con, ServerPreparedStatement preparedStatement) throws SQLException {
        this.close(con);
    }

    @Override
    public int getStatementId() {
        return this.statementId;
    }

    @Override
    public Column[] getParameters() {
        return this.parameters;
    }

    @Override
    public Column[] getColumns() {
        return this.columns;
    }

    @Override
    public void setColumns(Column[] columns) {
        this.columns = columns;
    }
}

